﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Genericka_lista
{
    /*Javni generički tip Lista, gde se garantuje da su 
     * elementi Liste međusobno uporedivi(IUporediv). Tip
Lista predstavlja implementaciju jednostruko povezane liste.
    */

    /*
        Javni genericki tip Lista<T> koja sadrzi genericke elemente 
        T gde se garantuje da su elementi (T) medjusobno uporedivi 
     */

    public class Element<T>
    {
        public T vrednost;
        public Element<T> sledeci;
    }

    class Lista<Tip> : IEnumerable where Tip : IUporediv<Tip>
    {
        Element<Tip> glava = null;
        Element<Tip> rep = null;

        int brojElemenata = 0;

        public int BrojElemenata
        {
            get
            {
                return brojElemenata;
            }
        }

        public Tip this[int pozicija]
        {
            get
            {
                Element<Tip> tmp = VratiElement(pozicija);
                return tmp.vrednost;
            }

            set
            {
                Element<Tip> tmp = VratiElement(pozicija);
                tmp.vrednost = value;
            }
        }

        private Element<Tip> VratiElement(int pozicija)
        {
            if (pozicija < 0 || pozicija >= BrojElemenata)
                throw new Exception("Neispravna pozicija");

            Element<Tip> tmp = glava;
            for (int i = 0; i < pozicija; i++)
                tmp = tmp.sledeci;
            return tmp;
        }

        //Konstruktor koji treba da prihvati vrednost
        //generičkog tipa i da je
        //postavi kao glavu liste. 
        public Lista(Tip vrednost)
        {
            Add(vrednost);
        }
        //Metodu Add koja prihvata generičku vrednost
        //i dodaje je u Listu. 
        public void Add(Tip novaVrednost)
        {
            Element<Tip> noviElement = new Element<Tip>();
            noviElement.vrednost = novaVrednost;

            if (glava == null)
            {
                glava = noviElement;
                rep = glava;
            }
            else
            {
                /*Element<Tip> tmp = glava;

                while (tmp.sledeci != null)
                {
                    tmp = tmp.sledeci;
                }

                tmp.sledeci = noviElement;*/

                rep.sledeci = noviElement;
                rep = noviElement;
            }

            brojElemenata++;
        }

        public IEnumerator GetEnumerator()
        {
            Element<Tip> tmp = glava;

            while (tmp != null)
            {
                yield return tmp.vrednost;
                tmp = tmp.sledeci;
            }
        }

        public void Sortiraj()
        {
            for (int i = 0; i < BrojElemenata - 1; i++)
            {
                for (int j = i + 1 ; j < BrojElemenata; j++)
                {
                    Tip t1 = this[i];
                    Tip t2 = this[j];

                    if (t1.Uporedi(t2) == 1)
                    {
                        this[i] = t2;
                        this[j] = t1;
                    }
                }
            }
        }

    }


    class Student : IUporediv<Student>
    {
        public string ime;
        public double prosek;
        
        public Student(string ime, double prosek)
        {
            this.ime = ime;
            this.prosek = prosek;
        }

        public override string ToString()
        {
            return ime + " - " + prosek;
        }

        //this > (t2) == 1
        public int Uporedi(Student s)
        {
            if (this.prosek > s.prosek)
                return 1;
            else if (this.prosek < s.prosek)
                return -1;
            else
                return 0;
        }
    }

}
